% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CIARA_core_functions.R
\name{CIARA}
\alias{CIARA}
\title{CIARA}
\usage{
CIARA(
  norm_matrix,
  knn_matrix,
  background,
  cores_number = 1,
  p_value = 0.001,
  odds_ratio = 2,
  local_region = 1,
  approximation = FALSE
)
}
\arguments{
\item{norm_matrix}{Norm count matrix (n_genes X n_cells).}

\item{knn_matrix}{K-nearest neighbors matrix (n_cells X n_cells).}

\item{background}{Vector of genes for which the function \emph{CIARA_gene}
is run.}

\item{cores_number}{Integer.Number of cores to use.}

\item{p_value}{p value returned by the function \emph{fisher.test} with
parameter alternative = "g"}

\item{odds_ratio}{odds_ratio returned by the function \emph{fisher.test}
with parameter alternative = "g"}

\item{local_region}{Integer. Minimum number of local regions (cell with its
knn neighbours) where the binarized gene expression is enriched in 1.}

\item{approximation}{Logical.For a given gene, the fisher test is run in the
local regions of only the cells where the binarized gene expression is 1.}
}
\value{
Dataframe with n_rows equal to the length of
\emph{background} . Each row is the output from \emph{CIARA_gene}.
}
\description{
It selects highly localized genes as specified in \emph{CIARA_gene},
starting from genes in \emph{background}
}
\author{
Gabriele Lubatti \email{gabriele.lubatti@helmholtz-muenchen.de}
}
