% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CDVineCopulaConditional.r
\name{CDVineCondRank}
\alias{CDVineCondRank}
\title{Ranking of C- and D- vines allowing for conditional simulation}
\usage{
CDVineCondRank(data, Nx, treecrit = "AIC", selectioncrit = "AIC",
  familyset = NA, type = "CVine-DVine", indeptest = FALSE, level = 0.05,
  se = FALSE, rotations = TRUE, method = "mle")
}
\arguments{
\item{data}{An \code{N x d} data matrix (with uniform margins).
Data of the conditioning variable(s) have to occupy the last column(s) of this matrix.}

\item{Nx}{Number of conditioning variables.}

\item{treecrit}{Character indicating the criteria used to select the vine. All possible vines are fitted trough 
the function \code{\link[VineCopula]{RVineCopSelect}} of the package \code{VineCopula}. Then the vines are ranked with respect 
the Akaike information criterion (\code{treecrit = "AIC"}, default) or Bayesian information criterion (\code{treecrit = "BIC"}). 
This need the estimation and model selection for all the pairs of all the possible vines, therefore could 
require long time in case of large datasets, i.e. large \code{N x d}.}

\item{selectioncrit}{Character indicating the criterion for pair-copula selection.
Possible choices are \code{selectioncrit = "AIC"} (default) and \code{"BIC"}.}

\item{familyset}{"Integer vector of pair-copula families to select from. The vector has to include at least one
pair-copula family that allows for positive and one that allows for negative
dependence. Not listed copula families might be included to better handle
limit cases.  If \code{familyset = NA} (default), selection among all
possible families is performed. If a vector of negative numbers is provided,
selection among all but \code{abs(familyset)} is performed. Coding of bivariate copula families: \cr
\code{0} = independence copula \cr
\code{1} = Gaussian copula \cr
\code{2} = Student t copula (t-copula) \cr
\code{3} = Clayton copula \cr
\code{4} = Gumbel copula \cr
\code{5} = Frank copula \cr
\code{6} = Joe copula \cr
\code{7} = BB1 copula \cr
\code{8} = BB6 copula \cr
\code{9} = BB7 copula \cr
\code{10} = BB8 copula \cr
\code{13} = rotated Clayton copula (180 degrees; ``survival Clayton'') \cr
\code{14} = rotated Gumbel copula (180 degrees; ``survival Gumbel'') \cr
\code{16} = rotated Joe copula (180 degrees; ``survival Joe'') \cr
\code{17} = rotated BB1 copula (180 degrees; ``survival BB1'')\cr
\code{18} = rotated BB6 copula (180 degrees; ``survival BB6'')\cr
\code{19} = rotated BB7 copula (180 degrees; ``survival BB7'')\cr
\code{20} = rotated BB8 copula (180 degrees; ``survival BB8'')\cr
\code{23} = rotated Clayton copula (90 degrees) \cr
\code{24} = rotated Gumbel copula (90 degrees) \cr
\code{26} = rotated Joe copula (90 degrees) \cr
\code{27} = rotated BB1 copula (90 degrees) \cr
\code{28} = rotated BB6 copula (90 degrees) \cr
\code{29} = rotated BB7 copula (90 degrees) \cr
\code{30} = rotated BB8 copula (90 degrees) \cr
\code{33} = rotated Clayton copula (270 degrees) \cr
\code{34} = rotated Gumbel copula (270 degrees) \cr
\code{36} = rotated Joe copula (270 degrees) \cr
\code{37} = rotated BB1 copula (270 degrees) \cr
\code{38} = rotated BB6 copula (270 degrees) \cr
\code{39} = rotated BB7 copula (270 degrees) \cr
\code{40} = rotated BB8 copula (270 degrees) \cr
\code{104} = Tawn type 1 copula \cr
\code{114} = rotated Tawn type 1 copula (180 degrees) \cr
\code{124} = rotated Tawn type 1 copula (90 degrees) \cr
\code{134} = rotated Tawn type 1 copula (270 degrees) \cr
\code{204} = Tawn type 2 copula \cr
\code{214} = rotated Tawn type 2 copula (180 degrees) \cr
\code{224} = rotated Tawn type 2 copula (90 degrees) \cr
\code{234} = rotated Tawn type 2 copula (270 degrees)" (VineCopula Documentation, version 2.1.1, pp. 73-74)}

\item{type}{Type of vine to be fitted: \cr
C-Vine: "CVine" or 1; \cr
D-Vine: "DVine" or 2; \cr
Both C and D-Vine: "CVine-DVine" or "1-2" (default).}

\item{indeptest}{"Logical; whether a hypothesis test for the independence of
\code{u1} and \code{u2} is performed before bivariate copula selection
(default: \code{indeptest = FALSE}; see \code{BiCopIndTest}).  The
independence copula is chosen for a (conditional) pair if the null
hypothesis of independence cannot be rejected.}

\item{level}{numeric; significance level of the independence test (default:
\code{level = 0.05}).}

\item{se}{Logical; whether standard errors are estimated (default: \code{se
= FALSE}).}

\item{rotations}{logical; if \code{TRUE}, all rotations of the families in
\code{familyset} are included.}

\item{method}{indicates the estimation method: either maximum
likelihood estimation (\code{method = "mle"}; default) or inversion of
Kendall's tau (\code{method = "itau"}). For \code{method = "itau"} only
one parameter families and the Student t copula can be used (\code{family =
1,2,3,4,5,6,13,14,16,23,24,26,33,34} or \code{36}). For the t-copula,
\code{par2} is found by a crude profile likelihood optimization over the
interval (2, 10]." (VineCopula Documentation, version 2.1.1, pp. 74-75)}
}
\value{
\describe{
\item{\code{table}}{A table with the ranking of the vines, with vine index \code{i},
values of the selected \code{treecrit} and vine \code{type} (1 for "CVine" and 2 for D-Vine).}

\item{\code{vines}}{A list where the element \code{[[i]]} is an \code{\link[VineCopula]{RVineMatrix}} object corresponding to
the \code{i}-th vine in the ranking shown in \code{table}. 
Each \code{\link[VineCopula]{RVineMatrix}} object containes the selected families (\code{$family}) as well as sequentially
estimated parameters stored in \code{$par} and \code{$par2}. Details about \code{\link[VineCopula]{RVineMatrix}} objects are given in 
the documentation file of the \code{VineCopula} package). 
The fit of each model is performed via the function \code{\link[VineCopula]{RVineCopSelect}} of the package \code{VineCopula}. 
"The object is augmented by the following information about the fit: 

\describe{
\item{\code{se, se2}}{standard errors for the parameter estimates  (if \code{se = TRUE}; note that these are only 
approximate since they do not account for the sequential nature of the estimation}

\item{\code{nobs}}{number of observations}

\item{\code{logLik, pair.logLik}}{log likelihood (overall and pairwise)}

\item{\code{AIC, pair.AIC}}{Aikaike's Informaton Criterion (overall and pairwise)}

\item{\code{BIC, pair.BIC}}{Bayesian's Informaton Criterion (overall and pairwise)}

\item{\code{emptau}}{matrix of empirical values of Kendall's tau}

\item{\code{p.value.indeptest}}{matrix of p-values of the independence test.}}
}}
}
\description{
Provides a ranking of the C- and D- vines which allow for conditional 
sampling, under the condition discussed in the descriprion of \code{\link{CDVineCondFit}}.
}
\note{
For a comprehensive summary of the vine copula model, use
\code{summary(object)}; to see all its contents, use \code{str(object)}." (VineCopula Documentation, version 2.1.1, pp. 103)
}
\examples{

# Read data
data(dataset)
data <- dataset$data[1:100,1:5]

# Define the variables Y and X. X are the conditioning variables, 
# which have to be positioned in the last columns of the data.frame
colnames(data) <- c("Y1","Y2","X3","X4","X5")

# Rank the possible D-Vines according to the AIC
\dontrun{
Ranking <- CDVineCondRank(data,Nx=3,"AIC",type="DVine")
Ranking$table
#    tree       AIC type
# 1     1 -292.8720    2
# 2     2 -290.2941    2
# 3     3 -288.5719    2
# 4     4 -288.2496    2
# 5     5 -287.8006    2
# 6     6 -285.8503    2
# 7     7 -282.2867    2
# 8     8 -278.9371    2
# 9     9 -275.8339    2
# 10   10 -272.9459    2
# 11   11 -271.1526    2
# 12   12 -270.5269    2

Ranking$vines[[1]]$AIC
# [1] -292.8720
summary(Ranking$vines[[1]])
}

}
\author{
Emanuele Bevacqua
}
\references{
Bevacqua, E., Maraun, D., Hobaek Haff, I., Widmann, M., and Vrac, M.: Multivariate statistical modelling of compound events via pair-copula constructions: analysis of floods in Ravenna (Italy), 
Hydrol. Earth Syst. Sci., 21, 2701-2723, https://doi.org/10.5194/hess-21-2701-2017, 2017.
\href{https://www.researchgate.net/publication/317414374_Multivariate_statistical_modelling_of_compound_events_via_pair-copula_constructions_Analysis_of_floods_in_Ravenna_Italy}{[link]} 
\href{https://www.hydrol-earth-syst-sci.net/21/2701/2017/hess-21-2701-2017.html}{[link]} 

Aas, K., Czado, C., Frigessi, A. and Bakken, H.: Pair-copula constructions of multiple dependence, Insurance:
Mathematics and Economics, 44(2), 182-198, <doi:10.1016/j.insmatheco.2007.02.001>, 2009. 
\href{http://www.sciencedirect.com/science/article/pii/S0167668707000194}{[link]} 

Ulf Schepsmeier, Jakob Stoeber, Eike Christian Brechmann, Benedikt Graeler, Thomas 
Nagler and Tobias Erhardt (2017). VineCopula: Statistical Inference of Vine Copulas. R 
package version 2.1.1. \href{https://CRAN.R-project.org/package=VineCopula}{[link]}
}
\seealso{
\code{\link{CDVineCondFit}}
}

