% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run-ed50-analysis.R
\name{define_grouping_property}
\alias{define_grouping_property}
\title{Define Grouping Property Column}
\usage{
define_grouping_property(dataset, grouping_properties, sep = "_")
}
\arguments{
\item{dataset}{A data frame where the new 'GroupingProperty' column will be added.}

\item{grouping_properties}{A character vector containing the names of the columns to be merged.}

\item{sep}{A character string used as a separator when merging columns (default is "_").}
}
\value{
A data frame with the added 'GroupingProperty' column.
}
\description{
This function creates a new column 'GroupingProperty' in the provided dataset by merging specified columns using a specified separator.
The new column is created as a factor variable.
}
\examples{
# Create a sample data frame
data <- data.frame(Category = c("A", "B", "C"),
                   Subcategory = c("X", "Y", "Z"),
                   Value = c(10, 20, 30))

# Define grouping property using 'Category' and 'Subcategory'
new_data <- define_grouping_property(data, c("Category", "Subcategory"), sep = "-")

# Resulting data frame:
#   Category Subcategory Value GroupingProperty
# 1        A           X    10              A-X
# 2        B           Y    20              B-Y
# 3        C           Z    30              C-Z
}
