% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boundary_segments.R
\name{boundary_segments}
\alias{boundary_segments}
\alias{boundary_segments_25N}
\alias{boundary_segments_26N}
\title{Azorean boundary segments}
\usage{
boundary_segments(crs = laea_azores_proj())

boundary_segments_25N()

boundary_segments_26N()
}
\arguments{
\item{crs}{Coordinate reference system (CRS) passed on to
\link[sf:st_transform]{st_transform()}. Defaults to a custom CRS centered on
the Azores, see \code{\link[=laea_azores_proj]{laea_azores_proj()}} for more details. Other possible
options are \code{"EPSG: 3035"} for ETRS89-extended / LAEA Europe or
\code{"EPSG:4326"} for WGS 84.}
}
\value{
A simple features (\link[sf:sf]{sf}) object with seven fields:

\describe{
\item{\code{id}}{An unique UUID identifier for the segment.}
\item{\code{id_at_right}}{Identifier for the entity at the right side of the boundary.}
\item{\code{id_at_left}}{Identifier for the entity at the left side of the boundary.}
\item{\code{is_confirmed}}{Boundary segment whose acceptance by the parties has
not yet been officially communicated.}
\item{\code{boundary_type}}{Boundary type: land or coast.}
\item{\code{boundary_level}}{Boundary level: administrative level.}
\item{\code{length}}{Boundary segment length in kilometers.}
}
}
\description{
\code{\link[=boundary_segments]{boundary_segments()}} returns the boundary segments that separate
administrative entities or borders with the Atlantic Ocean in the Azores.

\code{\link[=boundary_segments_25N]{boundary_segments_25N()}} returns the boundary segments in the meter-based projection PTRA08
/ UTM zone 25N, i.e. those boundary segments in the western-most part of the
archipelago: \emph{Ilha das Flores} and \emph{Ilha do Corvo}.

\code{\link[=boundary_segments_26N]{boundary_segments_26N()}} returns the boundary segments in the meter-based projection PTRA08
/ UTM zone 26N, i.e. those boundary segments in the Central and Eastern groups of
the archipelago.
}
\examples{
boundary_segments()
boundary_segments_25N()
boundary_segments_26N()

}
