% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc-data.R
\docType{data}
\name{CHARM}
\alias{CHARM}
\title{RCT In Chronic Heart Failure Assessing an Inhibitor of the Renin-Angiotensin System.}
\format{
An object of class \code{data.frame} with 3023 rows and 8 columns.
}
\usage{
data(CHARM, package = "BuyseTest")
}
\description{
Simulated data inspired from the CHARM-Preserved Trial comparing cardiovascular death or admission to hospital for chronic heart failure (CHF) among patients with CHF treated with candesartan or placebo.

\itemize{
\item \code{id}: study participant.
\item \code{treatment}: treatment arm: candesartan (T) or placebo (C).
\item \code{Mortality}: time from inclusion (say diagnosis) to death or loss to follow-up.
\item \code{statusMortality}: event triggering the end of follow-up: death (1), drop-out (0).
\item \code{Hospitalization}: time from inclusion (say diagnosis) to hospitalization or end of follow-up.
\item \code{statusHospitalization}: hospitalization (1) or end of follow-up (0).
\item \code{Composite}: time to hospitalization, death, or loss to follow-up, whichever comes first.
\item \code{statusComposite}: hospitalization or death (1), drop-out (0).
}
}
\references{
Yusuf Salim, et al. "Effects of candesartan in patients with chronic heart failure and preserved left-ventricular ejection fraction: the CHARM-Preserved Trial". The Lancet (2003) 9386(362):777-781.
}
\author{
Johan Verbeeck
}
\keyword{datasets}
