% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/etp_thorntwaite.R
\name{correction_etp_thornwaite}
\alias{correction_etp_thornwaite}
\title{Correction for Thorntwaite - Potential evapotranspiration}
\usage{
correction_etp_thornwaite(etp, date, lat)
}
\arguments{
\item{etp}{A column of a dataframe containing Thorntwaite potential evapotranspiration (ETp) data without adjustments for sunlight hours and the number of days in the month.".}

\item{date}{A column of dataframe with date (i.e: 2025-01-02).}

\item{lat}{A column of dataframe with latitude in degrees.}
}
\value{
Returns a vector object with the Thorntwaite ETp corrected for sunlight hours and the number of days in the month.
}
\description{
Correction for Thorntwaite - Potential evapotranspiration
}
\examples{
\dontrun{
etp_cor <- correction_etp_thornwaite(etp, date, lat)
}
}
\author{
Roberto Filgueiras.
}
