% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_oc_stock.R
\name{estimate_oc_stock}
\alias{estimate_oc_stock}
\title{Organic Carbon Stock estimation}
\usage{
estimate_oc_stock(
  df = NULL,
  depth = 100,
  core = "core",
  mind = "mind_corrected",
  maxd = "maxd_corrected",
  dbd = "dbd",
  oc = "eoc"
)
}
\arguments{
\item{df}{A data.frame with core (core id), mind (minimum depth of the
sample), maxd (maximum depth of the sample), dbd (dry bulk density), oc
(organic carbon \%)}

\item{depth}{mas depth to estimate the stock, by default 100.}

\item{core}{Character Name of the column reporting core ID.}

\item{mind}{Character Name of the column reporting the minimum depth of each sample.}

\item{maxd}{Character Name of the column reporting the maximum depth of each sample.}

\item{dbd}{Character Name of the column reporting dry bulk density.}

\item{oc}{Character Name of the column reporting organic carbon concentrations.}
}
\value{
data.frame with columns core, stockwc (organic carbon stock at the whole core),
maxd (maximum depth of the core), stock (organic carbon stock at the standardized depth),
and stock_se (standard error for the estimated stock).
}
\description{
Estimates carbon stocks from soil core data down to a specified
depth, 100 cm by default. If the core does not reach the standardized depth,
it extrapolates the stock from a linear model between accumulated mass of
organic carbon and depth.
}
\examples{
bluecarbon_decompact <- decompact(bluecarbon_data)

oc <- estimate_oc(bluecarbon_decompact)

out <- estimate_oc_stock(oc[[1]])
head(out)

}
