% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bivrecReg.R
\name{bivrecReg}
\alias{bivrecReg}
\title{Semiparametric Regression Analysis of Bivariate Alternating Recurrent Event Gap Time Data}
\usage{
bivrecReg(formula, data, method)
}
\arguments{
\item{formula}{A formula with a \verb{bivrecSurv} object on the left of a ~ operator as response, and the covariate(s) on the right.}

\item{data}{A data frame that includes the vectors needed for the \verb{bivrecSurv} response and the covariates in the formula.}

\item{method}{A string indicating which method to use to estimate effects of the covariates. See details.}
}
\value{
A bivrecReg object that contains:
\itemize{
  \item \verb{call}
  \item \verb{lee_fit} or \verb{chang_fit}
  \item \verb{formula}
  \item \verb{data}
}
}
\description{
This function allows the user to evaluate covariate effects on two alternating recurrent events gap times (referred as Type I and Type II gap times)
under the assumption that the two gap times follow accelerated failure time (AFT) models. See details for the estimation methods provided.
}
\details{
Two different estimation methods are available:
\itemize{
\item  \verb{method = "Lee.et.al"} (default) is a U-statistics-based smooth estimating function approach. See Lee, Huang, Xu, Luo (2018) for further details.
\item  \verb{method = "Chang"} is a rank-based estimating function approach.  See Chang (2004) for further details.
Note that following the Chang method, the variances of the estimated regression coefficients are approximated using the resampling techniques developed by Parzen, Wei, Ying (1994).
This approximation requires extensive computing time for a relatively small sample size. In addition, using the Chang method does not guarantee convergence for the estimation of the coefficients and user may get the message, "Error: Max iterations reached. Did not converge.".
}

Related methods: \verb{coef.bivrecReg}, \verb{confint.bivrecReg}, \verb{plot}, \verb{print}, \verb{summary.bivrecReg}, \verb{vcov.bivrecReg}.
}
\examples{

\dontrun{

library(BivRec)
set.seed(28)
# Simulate bivariate alternating recurrent event data
bivrec_data <- simBivRec(nsize=100, beta1=c(0.5,0.5), beta2=c(0,-0.5),
               tau_c=63, set=1.1)
# Apply Lee, Huang, Xu, Luo (2018) method using two covariates
lee_reg <- bivrecReg(bivrecSurv(id, epi, xij, yij, d1, d2) ~ a1 + a2,
                     bivrec_data, "Lee.et.al")
summary(lee_reg)

}

}
\references{
\enumerate{
\item Chang S-H. (2004). Estimating marginal effects in accelerated failure time models for serial sojourn times among repeated events. Lifetime Data Analysis, 10: 175-190.
\doi{10.1023/B:LIDA.0000030202.20842.c9}

\item Lee CH, Huang CY, Xu G, Luo X. (2018). Semiparametric regression analysis for alternating recurrent event data. Statistics in Medicine, 37: 996-1008.
\doi{10.1002/sim.7563}

\item Parzen MI, Wei LJ, Ying Z. (1994). A resampling method based on pivotal estimating functions. Biometrika, 81: 341-350.
\url{http://www.people.fas.harvard.edu/~mparzen/published/parzen1.pdf}
}
}
\keyword{bivrecReg}
