# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Return the group number for each localization.
#'
#' @description
#' Group PALM/iPALM localizations based on their physical separation distance
#'
#' PALM/iPALM data results in a list of spatial coordinates for fluorophore
#' localizations. This function groups nearby localizations if they are within
#' the provided critical distance from each other.
#'
#' @param input A numeric matrix where each row is a localization and each
#' column is a spatial axis.
#' @param critDist The critical distance for which localizations nearer than
#' this distance are deemed part of the same group.
#' @param use_prog_bar A logical indicating whether a progress bar should be
#' used. This must be set to false when running in parallel.
#'
#' @author Zach Colburn
#'
#' @examples
#' # Function call
#' \dontrun{.euclidean_linker_cpp(inputMatrix, critDist)}
#'
#' @import Rcpp
#'
#' @useDynLib Bioi, .registration = TRUE
.euclidean_linker_cpp <- function(input, critDist, use_prog_bar = TRUE) {
    .Call(`_Bioi_euclidean_linker_cpp`, input, critDist, use_prog_bar)
}

#' @title For all points in matrix 1, return the distance to and index of the
#' nearest point in matrix 2.
#'
#' @description
#' Find the shortest distance between each point in one data set and the points
#' in a second set.
#'
#' This function determines the distance between every point in data set 1 and
#' the points in data set 2. Unlike this function's naive counterpart,
#' find_min_dists, this function divides the PALM/iPALM localization data
#' into blocks, operates on the data in each block, and then performs linking
#' operations on neighboring blocks.
#'
#' @param mOne A numeric matrix where each row is a localization and each
#' column is a spatial axis.
#' @param mTwo A numeric matrix with the same number of columns as mOne.
#'
#' @author Zach Colburn
#'
#' @examples
#' \dontrun{
#' set.seed(10)
#'
#' mOne <- as.matrix(data.frame(
#' x = rnorm(10),
#' y = rbinom(10, 100, 0.5),
#' z = runif(10)
#' ))
#'
#' mTwo <- as.matrix(data.frame(
#' x = rnorm(20),
#' y = rbinom(20, 100, 0.5),
#' z = runif(20)
#' ))
#'
#' .find_min_dists_cpp(mOne, mTwo)
#'}
#'
#' @import Rcpp
#'
#' @useDynLib Bioi, .registration = TRUE
.find_min_dists_cpp <- function(mOne, mTwo) {
    .Call(`_Bioi_find_min_dists_cpp`, mOne, mTwo)
}

