% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BioCircos.R
\name{BioCircosTextTrack}
\alias{BioCircosTextTrack}
\title{Create a Text track to be added to a BioCircos tracklist}
\usage{
BioCircosTextTrack(trackname, text, x = -0.15, y = 0, size = "1.2em",
  weight = "bold", opacity = 1, color = "#000000", ...)
}
\arguments{
\item{trackname}{The name of the new track.}

\item{text}{The text to be displayed.}

\item{x, y}{Coordinates of the lower left corner of the annotation, in proportion of the inner radius of the plot.}

\item{size}{Font size, with units specified (such as em or px).}

\item{weight}{Font weight. Can be "normal", "bold", "bolder" or "lighter".}

\item{opacity}{Font opacity.}

\item{color}{Font color, in hexadecimal RGB format.}

\item{...}{Ignored}
}
\description{
Simple text annotation displayed in the visualization
}
\examples{
BioCircos(BioCircosTextTrack('textTrack', 'Annotation', color = '#DD2222', x = -0.3))

}
