% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BioCircos.R
\name{BioCircosLinkTrack}
\alias{BioCircosLinkTrack}
\title{Create an inner track with links to be added to a BioCircos tracklist}
\usage{
BioCircosLinkTrack(trackname, gene1Chromosomes, gene1Starts, gene1Ends,
  gene2Chromosomes, gene2Starts, gene2Ends, color = "#40B9D4",
  labels = "", maxRadius = 0.4, width = "0.1em", gene1Names = "",
  gene2Names = "", displayAxis = TRUE, axisColor = "#B8B8B8",
  axisWidth = 0.5, axisPadding = 0, displayLabel = TRUE,
  labelColor = "#000000", labelSize = "1em", labelPadding = 3, ...)
}
\arguments{
\item{trackname}{The name of the new track.}

\item{gene1Chromosomes, gene1Starts, gene1Ends, gene1Names, gene2Chromosomes, gene2Starts, gene2Ends, gene2Names}{Vectors with the chromosomes, genomic coordinates of beginning and end, and names of both genes to link.
Chromosomes and positions should respect the chromosome names and lengths given in the genome parameter of
the BioCircos function.}

\item{color}{The color for the links, in hexadecimal RGB format.}

\item{labels}{A vector of character objects to label each link.}

\item{maxRadius}{Where the track should end, in proportion of the inner radius of the plot.}

\item{width}{The thickness of the links.}

\item{displayAxis}{Display additional axis (i.e. circle) around the track.}

\item{axisColor, axisWidth, axisPadding}{Color, thickness and padding of the additional axis.}

\item{displayLabel}{Display labels of the track.}

\item{labelColor, labelSize, labelPadding}{Color, font size and padding of the labels around the track.}

\item{...}{Ignored}
}
\description{
Links are defined by beginning and ending genomic coordinates of the 2 regions to linked,
 such as the positions linked in genomic fusions.
}
\examples{
start_chromosomes <- 1:5
end_chromosomes <- 2*10:6
start_pos <- 2.5e+7*2:6
end_pos <- 2e+7*1:5
BioCircos(BioCircosLinkTrack('LinkTrack', start_chromosomes, start_pos, start_pos+1,
  end_chromosomes, end_pos, end_pos+1, color = '#FF00FF'))

}
