/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic;

import dr.evomodel.antigenic.ContinuousAntigenicTraitLikelihood;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.CommonCitations;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.Arrays;
import java.util.List;

@Deprecated
public class AntigenicSplitPrior
extends AbstractModelLikelihood
implements Citable {
    public static final String ANTIGENIC_SPLIT_PRIOR = "antigenicSplitPrior";
    private final int dimension;
    private final int count;
    private final Parameter datesParameter;
    private final MatrixParameter locationsParameter;
    private final Parameter regressionSlopeParameter;
    private final Parameter regressionPrecisionParameter;
    private final Parameter splitTimeParameter;
    private final Parameter splitAngleParameter;
    private final Parameter splitAssignmentParameter;
    private final int[] topBranchIndices;
    private final int[] bottomBranchIndices;
    private double earliestDate;
    private double logLikelihood = 0.0;
    private double storedLogLikelihood = 0.0;
    private boolean likelihoodKnown = false;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String LOCATIONS = "locations";
        public static final String DATES = "dates";
        public static final String REGRESSIONSLOPE = "regressionSlope";
        public static final String REGRESSIONPRECISION = "regressionPrecision";
        public static final String SPLITTIME = "splitTime";
        public static final String SPLITANGLE = "splitAngle";
        public static final String SPLITASSIGNMENT = "splitAssignment";
        public static final String TOPBRANCH = "topBranch";
        public static final String BOTTOMBRANCH = "bottomBranch";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("locations", MatrixParameter.class), new ElementRule("dates", Parameter.class), new ElementRule("regressionSlope", Parameter.class), new ElementRule("regressionPrecision", Parameter.class), new ElementRule("splitTime", Parameter.class), new ElementRule("splitAngle", Parameter.class), new ElementRule("splitAssignment", Parameter.class), AttributeRule.newStringArrayRule("topBranch", true, "A list of virus names to assign to the top branch."), AttributeRule.newStringArrayRule("bottomBranch", true, "A list of virus names to assign to the bottom branch.")};

        @Override
        public String getParserName() {
            return AntigenicSplitPrior.ANTIGENIC_SPLIT_PRIOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject.getElementFirstChild(LOCATIONS);
            Parameter parameter = (Parameter)xMLObject.getElementFirstChild(DATES);
            Parameter parameter2 = (Parameter)xMLObject.getElementFirstChild(REGRESSIONSLOPE);
            Parameter parameter3 = (Parameter)xMLObject.getElementFirstChild(REGRESSIONPRECISION);
            Parameter parameter4 = (Parameter)xMLObject.getElementFirstChild(SPLITTIME);
            Parameter parameter5 = (Parameter)xMLObject.getElementFirstChild(SPLITANGLE);
            Parameter parameter6 = (Parameter)xMLObject.getElementFirstChild(SPLITASSIGNMENT);
            Object var9_9 = null;
            List<String> list = null;
            String[] stringArray = xMLObject.getStringArrayAttribute(TOPBRANCH);
            if (stringArray != null) {
                list = Arrays.asList(stringArray);
            }
            List<String> list2 = null;
            String[] stringArray2 = xMLObject.getStringArrayAttribute(BOTTOMBRANCH);
            if (stringArray2 != null) {
                list2 = Arrays.asList(stringArray2);
            }
            AntigenicSplitPrior antigenicSplitPrior = new AntigenicSplitPrior(matrixParameter, parameter, parameter2, parameter3, parameter4, parameter5, parameter6, list, list2);
            return antigenicSplitPrior;
        }

        @Override
        public String getParserDescription() {
            return "Provides the likelihood of a vector of coordinates in some multidimensional 'antigenic' space based on an expected relationship with time.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return ContinuousAntigenicTraitLikelihood.class;
        }
    };

    public AntigenicSplitPrior(MatrixParameter matrixParameter, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Parameter parameter5, Parameter parameter6, List<String> list, List<String> list2) {
        super(ANTIGENIC_SPLIT_PRIOR);
        this.locationsParameter = matrixParameter;
        this.addVariable(this.locationsParameter);
        this.datesParameter = parameter;
        this.addVariable(this.datesParameter);
        this.dimension = matrixParameter.getParameter(0).getDimension();
        this.count = matrixParameter.getParameterCount();
        this.earliestDate = parameter.getParameterValue(0);
        double d = parameter.getParameterValue(0);
        for (int i = 0; i < this.count; ++i) {
            double d2 = parameter.getParameterValue(i);
            if (this.earliestDate > d2) {
                this.earliestDate = d2;
            }
            if (!(d < d2)) continue;
            d = d2;
        }
        double d3 = d - this.earliestDate;
        this.regressionSlopeParameter = parameter2;
        this.addVariable(parameter2);
        parameter2.addBounds(new Parameter.DefaultBounds(Double.MAX_VALUE, 0.0, 1));
        this.regressionPrecisionParameter = parameter3;
        this.addVariable(parameter3);
        parameter3.addBounds(new Parameter.DefaultBounds(Double.MAX_VALUE, 0.0, 1));
        this.splitTimeParameter = parameter4;
        this.addVariable(parameter4);
        parameter4.addBounds(new Parameter.DefaultBounds(50.0, 20.0, 1));
        this.splitAngleParameter = parameter5;
        this.addVariable(parameter5);
        parameter5.addBounds(new Parameter.DefaultBounds(1.5707963267948966, 0.01, 1));
        this.splitAssignmentParameter = parameter6;
        this.addVariable(parameter6);
        parameter6.addBounds(new Parameter.DefaultBounds(1.0, 0.0, 1));
        String[] stringArray = new String[this.count];
        parameter6.setDimension(this.count);
        this.topBranchIndices = new int[list.size()];
        this.bottomBranchIndices = new int[list2.size()];
        for (int i = 0; i < this.count; ++i) {
            String string;
            int n;
            String string2;
            stringArray[i] = string2 = parameter.getDimensionName(i);
            parameter6.setParameterValueQuietly(i, 0.0);
            for (n = 0; n < list.size(); ++n) {
                string = list.get(n);
                if (!string.equals(string2)) continue;
                this.topBranchIndices[n] = i;
                parameter6.setParameterValueQuietly(i, 1.0);
            }
            for (n = 0; n < list2.size(); ++n) {
                string = list2.get(n);
                if (!string.equals(string2)) continue;
                this.bottomBranchIndices[n] = i;
                parameter6.setParameterValueQuietly(i, 0.0);
            }
        }
        parameter6.setDimensionNames(stringArray);
        this.likelihoodKnown = false;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.locationsParameter || variable == this.datesParameter || variable == this.regressionSlopeParameter || variable == this.regressionPrecisionParameter || variable == this.splitTimeParameter || variable == this.splitAngleParameter || variable == this.splitAssignmentParameter) {
            this.likelihoodKnown = false;
        }
    }

    @Override
    protected void storeState() {
        this.storedLogLikelihood = this.logLikelihood;
    }

    @Override
    protected void restoreState() {
        this.logLikelihood = this.storedLogLikelihood;
        this.likelihoodKnown = false;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.computeLogLikelihood();
        }
        return this.logLikelihood;
    }

    private double computeLogLikelihood() {
        double d = 0.0;
        double d2 = this.regressionPrecisionParameter.getParameterValue(0);
        d += 0.5 * Math.log(d2) * (double)this.count - 0.5 * d2 * this.sumOfSquaredResiduals();
        this.likelihoodKnown = true;
        return d += this.assignmentLikelihood();
    }

    protected double assignmentLikelihood() {
        int n;
        double d = 0.0;
        for (int n2 : this.topBranchIndices) {
            n = (int)this.splitAssignmentParameter.getParameterValue(n2);
            if (n != 0) continue;
            d -= 1000.0;
        }
        for (int n2 : this.bottomBranchIndices) {
            n = (int)this.splitAssignmentParameter.getParameterValue(n2);
            if (n != 1) continue;
            d -= 1000.0;
        }
        return d;
    }

    protected double sumOfSquaredResiduals() {
        double d = 0.0;
        for (int i = 0; i < this.count; ++i) {
            Parameter parameter = this.locationsParameter.getParameter(i);
            double d2 = parameter.getParameterValue(0);
            double d3 = this.expectedAG1(i);
            d += (d2 - d3) * (d2 - d3);
            if (this.dimension > 1) {
                d2 = parameter.getParameterValue(1);
                d3 = this.expectedAG2(i);
                d += (d2 - d3) * (d2 - d3);
            }
            for (int j = 2; j < this.dimension; ++j) {
                d2 = parameter.getParameterValue(j);
                d += d2 * d2;
            }
        }
        return d;
    }

    protected double expectedAG1(int n) {
        double d = this.datesParameter.getParameterValue(n);
        double d2 = 0.0;
        double d3 = d - this.earliestDate;
        double d4 = this.splitTimeParameter.getParameterValue(0);
        double d5 = this.splitAngleParameter.getParameterValue(0);
        double d6 = this.regressionSlopeParameter.getParameterValue(0);
        d2 = d3 <= d4 ? d6 * d3 : d6 * d4 + d6 * (d3 - d4) * Math.cos(d5);
        return d2;
    }

    protected double expectedAG2(int n) {
        double d = this.datesParameter.getParameterValue(n);
        int n2 = (int)this.splitAssignmentParameter.getParameterValue(n);
        double d2 = 0.0;
        double d3 = d - this.earliestDate;
        double d4 = this.splitTimeParameter.getParameterValue(0);
        double d5 = this.splitAngleParameter.getParameterValue(0);
        double d6 = this.regressionSlopeParameter.getParameterValue(0);
        d2 = d3 <= d4 ? 0.0 : d6 * (d3 - d4) * Math.sin(d5);
        if (n2 == 1) {
            d2 = -1.0 * d2;
        }
        return d2;
    }

    @Override
    public void makeDirty() {
        this.likelihoodKnown = false;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TRAIT_MODELS;
    }

    @Override
    public String getDescription() {
        return "Bayesian Antigenic Cartography framework";
    }

    @Override
    public List<Citation> getCitations() {
        return Arrays.asList(CommonCitations.BEDFORD_2015_INTEGRATING);
    }
}

