% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_dominance.R
\name{predict_dominance}
\alias{predict_dominance}
\title{Predict hemispheric dominance}
\usage{
predict_dominance(
  data,
  parameters = dplyr::tibble(dominance = rep(c("left", "right", "none"), each = 2),
    handedness = rep(c("left", "right"), 3), mean_li = c(10, 12, -24, -24, 0, 0), sd_li =
    c(24.9, 17, 24.9, 17, 22, 22), prob_dominance = c(0.65, 0.87, 0.35, 0.13, 0, 0)),
  truncation = c(-100, 100),
  icc = 0
)
}
\arguments{
\item{data}{Data frame with the following columns:
\itemize{
\item \code{listening}: Score between -100 and 100.
\item \code{handedness}: \code{"left"} for adextral (non-right-handed) and
      \code{"right"} for dextral (right-handed)
      }
 In addition, an optional column named \code{ID}
  can be provided, giving the subject ID. If a subject has multiple
  measurements, the posterior based on all measurements is provided. If the
  \code{ID} column is missing, each row is assumed to be measured on a
  separate subject.}

\item{parameters}{Data frame in which the first two columns specify combinations
of hemispheric dominance and handedness and the last three columns specify
the corresponding parameter values. In particular, the columns are defined as follows:
\itemize{
\item \code{dominance}: character specifying hemispheric dominance.
\item \code{handedness}: character specifying handedness.
\item \code{mean_li}: mean dichotic listening score.
\item \code{sd_li}: standard deviation of dichotic listening score.
\item \code{prob_dominance}: probability of hemispheric dominance given handedness.
}}

\item{truncation}{Numeric vector with two elements specifying the lower and upper
bounds for truncation of the normal distribution for dichotic listening scores.}

\item{icc}{Intraclass correlation for repeated measurements on the same individual.
Defaults to 0.}
}
\value{
The probability of left or right hemispheric dominance in additional
  columns of \code{data}.
}
\description{
Predict hemispheric dominance based on observed laterality measures, using the methods
described in \insertCite{Sorensen2020;textual}{BayesianLaterality}.
}
\examples{
# The package comes with two example datasets.
# The first contains single measurements on three subjects.
# We can first take a look at the data
example_data1
# Next, compute predictions.
# Since there is no ID column, predict_dominance() will print a message telling
# the user that the rows are assumed to contain observations from different subjects.
predict_dominance(example_data1)

# The next example dataset contains repeated measurements
example_data2

# We compute the predictions as before:
predict_dominance(example_data2)

}
\references{
\insertAllCited{}
}
