% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpPolar-functions.R
\name{alphaTheta}
\alias{alphaTheta}
\title{One-to-one polar transformation}
\usage{
alphaTheta(theta)
}
\arguments{
\item{theta}{Numeric vector of angles (in radians) of length \eqn{p-1},
which parameterize a point on \eqn{\mathbb{S}^{p-1}}.}
}
\value{
A numeric vector \eqn{\alpha} of length \eqn{p = \mathrm{length}(\theta)+1}
with unit Euclidean norm and \eqn{\alpha_1 \ge 0}.
}
\description{
The \pkg{nimble} function that converts \code{theta} (angles in radians) of length \eqn{p-1} into a
unit-norm vector \eqn{\alpha \in \mathbb{R}^p} on the unit sphere \eqn{\mathbb{S}^{p-1}}
using one-to-one polar transformation. For numerical
stability, the result is renormalized, and for identification the sign is
flipped so that \eqn{\alpha_1 \ge 0}.
}
\details{
Let \eqn{p = \mathrm{length}(\theta) + 1}. The mapping is
\deqn{
\begin{aligned}
\alpha_1 &= \sin(\theta_1),\\
\alpha_i &= \Big(\prod_{j=1}^{i-1}\cos(\theta_j)\Big)\sin(\theta_i), \quad i=2,\dots,p-1,\\
\alpha_p &= \prod_{j=1}^{p-1}\cos(\theta_j).
\end{aligned}
}
The vector is then scaled to unit length, \eqn{\alpha \leftarrow \alpha / \|\alpha\|_2}.
Finally, if \eqn{\alpha_1 < 0}, the vector is negated so that \eqn{\alpha_1 \ge 0},
restricting to a single hemisphere to avoid sign indeterminacy.

Typical angle domains (not enforced here) are: \eqn{\theta_1,\dots,\theta_{p-1} \in [0,\pi]}.
}
\seealso{
\code{\link{gpPolar}}, \code{\link{gpPolarHigh}}, \code{\link{predict.bsimGp}}
}
