% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssdSig.R
\name{successRegionSig}
\alias{successRegionSig}
\title{Success region based on significance}
\usage{
successRegionSig(sr, to, tau = 0, nsites = 1, level)
}
\arguments{
\item{sr}{Replication standard error}

\item{to}{Original effect estimate}

\item{tau}{Heterogeneity standard deviation used in the calculation of the
meta-analytic replication effect estimate and its standard error.
Defaults to \code{0} (fixed effects analysis)}

\item{nsites}{nsites Number of sites, defaults to \code{1}. The effect
estimates from all sites are assumed to have the same standard error
\code{sr}}

\item{level}{Significance level for p-value of the (average) replication
effect estimate (one-sided and in the same direction as the original
effect estimate)}
}
\value{
An object of class \code{"successRegion"}. See
    \code{\link{successRegion}} for details.
}
\description{
This function returns the success region for the (meta-analytic)
    replication effect estimate to achieve significance
}
\examples{
successRegionSig(sr = 0.05, to = 0.2, tau = 0.01, nsites = 3, level = 0.025)

}
\references{
Pawel, S., Consonni, G., and Held, L. (2022). Bayesian approaches to
designing replication studies. arXiv preprint.
\doi{10.48550/arXiv.2211.02552}
}
\author{
Samuel Pawel
}
