% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssdPs.R
\name{ssdPs}
\alias{ssdPs}
\title{Sample size determination for replication success based on
    the sceptical p-value}
\usage{
ssdPs(level, dprior, power)
}
\arguments{
\item{level}{Threshold for the (one-sided) sceptical p-value below which
replication success is achieved}

\item{dprior}{Design prior object}

\item{power}{Desired probability of replication success}
}
\value{
Returns an object of class \code{"ssdRS"}. See \code{\link{ssd}} for
    details.
}
\description{
This function computes the standard error required to achieve
    replication success with a certain probability and based on the sceptical
    p-value.
}
\details{
The sceptical p-value is assumed to be uncalibrated as in Held
    (2020). The package ReplicationSuccess allows for sample size and power
    calculations with the recalibrated sceptical p-value
    (\url{https://CRAN.R-project.org/package=ReplicationSuccess}).
}
\examples{
## specify design prior
to1 <- 0.2
so1 <- 0.05
dprior <- designPrior(to = to1, so = so1, tau = 0.03)
ssdPs(level = 0.05, dprior = dprior, power = 0.9)

}
\references{
Pawel, S., Consonni, G., and Held, L. (2022). Bayesian approaches to
designing replication studies. arXiv preprint.
\doi{10.48550/arXiv.2211.02552}

Held, L. (2020). A new standard for the analysis and design of replication
studies (with discussion). Journal of the Royal Statistical Society: Series A
(Statistics in Society), 183(2), 431-448. \doi{10.1111/rssa.12493}
}
\author{
Samuel Pawel
}
