% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssdBF01.R
\name{ssdBF01}
\alias{ssdBF01}
\title{Sample size determination for replication success based on
    Bayes factor}
\usage{
ssdBF01(
  level,
  dprior,
  power,
  priormean = 0,
  priorvar = 1,
  searchInt = c(.Machine$double.eps^0.5, 2)
)
}
\arguments{
\item{level}{Bayes factor level below which replication success is achieved}

\item{dprior}{Design prior object}

\item{power}{Desired probability of replication success}

\item{priormean}{Mean of the normal prior under the alternative. Defaults to
\code{0}}

\item{priorvar}{Variance of the normal prior under the alternative. Defaults
to \code{1}}

\item{searchInt}{Interval for numerical search over replication standard
errors}
}
\value{
Returns an object of class \code{"ssdRS"}. See \code{\link{ssd}} for
    details.
}
\description{
This function computes the standard error required to achieve
    replication success with a certain probability and based on the Bayes
    factor under normality. The Bayes factor is oriented so that values above
    one indicate evidence for the null hypothesis of the effect size being
    zero, whereas values below one indicate evidence for the hypothesis of
    the effect size being non-zero (with normal prior assigned to it).
}
\examples{
## specify design prior
to1 <- 0.2
so1 <- 0.05
dprior <- designPrior(to = to1, so = so1, tau = 0.03)
ssdBF01(level = 1/10, dprior = dprior, power = 0.8)

}
\references{
Pawel, S., Consonni, G., and Held, L. (2022). Bayesian approaches to
designing replication studies. arXiv preprint.
\doi{10.48550/arXiv.2211.02552}
}
\author{
Samuel Pawel
}
