% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssdMeta.R
\name{porsMeta}
\alias{porsMeta}
\title{Probability of replication success based on meta-analytic significance}
\usage{
porsMeta(level, dprior, sr)
}
\arguments{
\item{level}{Significance level for p-value of the meta-analytic effect
estimate (one-sided and in the same direction as the original effect
estimate)}

\item{dprior}{Design prior object}

\item{sr}{Replication standard error}
}
\value{
The probability to achieve replication success
}
\description{
This function computes the probability to achieve replication
    success on statistical significance of the fixed-effects meta-analytic
    effect estimate obtained from combining original and replication effect
    estimates.
}
\examples{
## specify design prior
to1 <- 2
so1 <- 1
dprior <- designPrior(to = to1, so = so1, tau = 0.1)
porsMeta(level = 0.025^2, dprior = dprior, sr = c(0.2, 0.1))

}
\references{
Pawel, S., Consonni, G., and Held, L. (2022). Bayesian approaches to
designing replication studies. arXiv preprint.
\doi{10.48550/arXiv.2211.02552}
}
\author{
Samuel Pawel
}
