% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_updates.R
\name{.shuffle_split_point_location}
\alias{.shuffle_split_point_location}
\title{Metropolis Hastings step: shuffle the split point locations (with 
Bayesian borrowing)}
\usage{
.shuffle_split_point_location(
  df_hist,
  df_curr,
  Y_0,
  I_0,
  X_0,
  lambda_0,
  beta_0,
  Y,
  I,
  X,
  lambda,
  beta,
  s,
  J,
  bp_0,
  bp,
  clam_smooth,
  maxSj
)
}
\arguments{
\item{df_hist}{dataframe containing historical trial data and parmaeters}

\item{df_curr}{data.frame containing current trial data and parameters}

\item{Y_0}{historical trial data}

\item{I_0}{historical trial censoring indicator}

\item{X_0}{historical trial design matrix}

\item{lambda_0}{historical baseline hazard}

\item{beta_0}{historical parameter vector}

\item{Y}{data}

\item{I}{censoring indicator}

\item{X}{design matrix}

\item{lambda}{baseline hazard}

\item{beta}{parameter vector}

\item{s}{split point locations, J + 2}

\item{J}{number of split points}

\item{bp_0}{number of covariates in historical trial}

\item{bp}{number of covariates in current trial}

\item{clam_smooth}{neighbor interactions, in range (0, 1), for ICAR update}

\item{maxSj}{the smallest of the maximal time points, min(max(Y), max(Y_0))}
}
\value{
list containing new split points, updated Sigma_s and data.frames
for historic and current trial data
}
\description{
Metropolis Hastings step: shuffle the split point locations (with 
Bayesian borrowing)
}
