% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RJMCMC.R
\name{.J_RJMCMC_NoBorrow}
\alias{.J_RJMCMC_NoBorrow}
\title{RJMCMC (without Bayesian Borrowing)}
\usage{
.J_RJMCMC_NoBorrow(
  df,
  Y_0,
  I_0,
  X_0,
  lambda_0,
  beta_0,
  mu,
  sigma2,
  s,
  J,
  Jmax,
  bp_0,
  clam_smooth,
  phi,
  pi_b
)
}
\arguments{
\item{df}{data_frame}

\item{Y_0}{data}

\item{I_0}{censoring indicator}

\item{X_0}{design matrix}

\item{lambda_0}{baseline hazard}

\item{beta_0}{historical trial parameters}

\item{mu}{prior mean for baseline hazard}

\item{sigma2}{prior variance hyperparameter for baseline hazard}

\item{s}{split point locations, J + 2}

\item{J}{number of split points}

\item{Jmax}{maximum number of split points}

\item{bp_0}{number of covariates in historical trial}

\item{clam_smooth}{neighbor interactions, in range (0, 1), for ICAR update}

\item{phi}{J hyperparameter}

\item{pi_b}{probability of birth move}
}
\value{
list of proposed J and s, with adjusted values of lambda, lambda_0, 
tau, Sigma_s, and data_frames for historical and current trial data
}
\description{
Metropolis-Hastings Green Reversible Jump move, without Bayesian 
Borrowing
}
