% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OneSampleNormal2.R
\name{OneSampleNormal2}
\alias{OneSampleNormal2}
\title{One sample Normal model with two-parameter unknown - both mean and variance unknown}
\usage{
OneSampleNormal2(
  prior,
  N = 100,
  mu0,
  mu1,
  var0,
  var,
  d = 0,
  ps = 0.95,
  pf = 0.05,
  alternative = c("less", "greater"),
  seed = 202209,
  sim = 5000
)
}
\arguments{
\item{prior}{A list of length 3 containing the distributional information of the prior.
The first element is a number specifying the type of prior. Options are
\enumerate{
\item DIP ;
\item Normal(mu0,var/k) and var ~ Inverse-Gamma(v/2, v*var0/2)

where mu0 = prior mean, k = sample size of prior observations (Normal prior),

v = sample size of prior observations (Gamma prior), var0 = prior sample variance}
The second and third elements of the list are the parameters k and v, respectively.}

\item{N}{The planned sample size.}

\item{mu0}{The null mean value, which could be taken as the standard or current mean.}

\item{mu1}{The mean value of the new treatment.}

\item{var0}{The prior sample variance}

\item{var}{The variance}

\item{d}{The target improvement (minimal clinically meaningful difference).}

\item{ps}{The efficacy boundary (upper boundary).}

\item{pf}{The futility boundary (lower boundary).}

\item{alternative}{less (lower values imply greater efficacy) or greater (larger
values imply greater efficacy).}

\item{seed}{The seed for simulations.}

\item{sim}{The number of simulations.}
}
\value{
A list of the arguments with method and computed elements.
}
\description{
For a given planned sample size, the efficacy and futility boundaries,
return the power, the type I error, the expected sample size and its
standard deviation, the probability of reaching the efficacy and futility boundaries.
}
\examples{
# with traditional Bayesian prior Beta(1,1)
OneSampleNormal2(list(2,2,1), N = 100, mu0 = 100, mu1 = 95, var0=225, var=225, d = 0,
                        ps = 0.95, pf = 0.05, alternative = "less",
                        seed = 202210, sim = 10)
# with DIP
OneSampleNormal2(list(1,0,0), N = 100, mu0 = 100, mu1 = 95, var0=225, var=225, d = 0,
                        ps = 0.95, pf = 0.05, alternative = "less",
                        seed = 202210, sim = 10)
}
