% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestplot.R
\name{forestplot}
\alias{forestplot}
\title{Forest plot}
\usage{
forestplot(x, range = NULL, xlab = "Effect size", ylab = "Study", ...,
  labels = NULL)
}
\arguments{
\item{x}{An object of the class \code{EV}.}

\item{range}{A numeric vector of length two that sets the range of the
x-axis. Values are passed to \code{xlim}. Sensible default values are used
when \code{range = NULL}.}

\item{xlab, ylab}{Text for the x and y axes labels.}

\item{...}{Other options passed to \code{plot()}.}

\item{labels}{Names for studies to be plotted on the y-axis. If \code{NULL},
then numbers are used.}
}
\value{
A forest plot.
}
\description{
Plots the effect sizes and standard errors for a set of studies
as a standard forest plot. Also shown are the priors for each study.
}
\details{
This function plots results from the \code{ev.combo()} function. The
results may be hard to visualise if the effect sizes differ greatly, and it
may be preferable to standardise the effect sizes by setting \code{scale =
TRUE} in the \code{ev.combo()} function.
}
\examples{
x <- ev.combo( beta = c(0.0126, 5.0052, 1.2976, 0.0005),
       se.beta = c(0.050, 2.581, 2.054, 0.003) )
forestplot(x)

}
\seealso{
\code{\link{ev.combo}}
}

