% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postK.R
\name{postK}
\alias{postK}
\title{Marginal probability of K}
\usage{
postK(kstar, w, M, Y, cluster, sigma2, lambda, clusteri)
}
\arguments{
\item{kstar}{A scalar with the number maximum of change points in all clusters}

\item{w}{A scalar representing the minimum number of points in each interval between two change points}

\item{M}{A scalar representing the number of points available for each data sequence}

\item{Y}{A matrix M x N with the data sequences}

\item{cluster}{A vector containing the cluster assignments for the data sequences (or its initial values)}

\item{sigma2}{A vector with the variances of the data sequences (or its initial values)}

\item{lambda}{A scalar defining the parameter for the Truncate Poisson distribution
that controls the number of change points (or its initial values)}

\item{clusteri}{A scalar with the index of a cluster}
}
\value{
A numerical value corresponding to the sampled number of change points, k, for a given cluster
}
\description{
Marginal probability of K
}
\note{
This function is called within the Gibbs sampler, but it can also de called separately.
}
\examples{
postK(kstar = 2, w = 10, M = 50, Y = data, cluster = c(1,1,2,1,2),
sigma2 = apply(data, 2, var), lambda = 2, clusteri = 1)

}
\seealso{
[gibbs_alg()]
}
