% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Format_BaHZING.R
\name{Format_BaHZING}
\alias{Format_BaHZING}
\title{Format_BaHZING Function}
\arguments{
\item{phyloseq.object}{A phyloseq object.}
}
\value{
A list with the following elements:
\itemize{
\item \code{Table}: Formatted microbiome data as a data frame.
\item \code{Species.Genus.Matrix}: Data frame for species-genus relationships (optional).
\item \code{Genus.Family.Matrix}: Data frame for genus-family relationships (optional).
\item \code{Family.Order.Matrix}: Data frame for family-order relationships (optional).
\item \code{Order.Class.Matrix}: Data frame for order-class relationships (optional).
\item \code{Class.Phylum.Matrix}: Data frame for class-phylum relationships (optional).
}
}
\description{
This function takes a phyloseq object and performs formatting operations on it,
including modifying the taxonomic table, uniting taxonomic levels, and creating
matrices based on taxonomic information.
}
\details{
The Format_BaHZING function is the core function of the Format_BaHZING package.
It takes a phyloseq object as input and performs various formatting operations
to prepare the data for analysis. The function modifies the taxonomic table to add
taxonomic prefixes (e.g., "d__" for Kingdom), unites taxonomic levels, and creates
matrices based on taxonomic information. The formatted data is then returned as a list
containing different data frames for further analysis.

The package relies on the \code{phyloseq}, \code{dplyr}, and \code{stringr} packages for data manipulation,
and also uses functions from \code{tidyr} to unite taxonomic levels.

The main function \code{Format_BaHZING} is exported and can be accessed by other packages or scripts
that depend on the functionalities provided by this package.

The column names 'Kingdom', 'Phylum', 'Class', 'Order', 'Family', 'Genus', and 'Species'
in the tax_table of the phyloseq object should be user-defined and assigned in this function.
The function will use these column names to perform various operations.
}
\note{
The column names 'Kingdom', 'Phylum', 'Class', 'Order', 'Family', 'Genus', and 'Species' in the
tax_table are expected to be user-defined and assigned within the function.
}
