% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_func.R
\name{ResultTableSummary}
\alias{ResultTableSummary}
\title{Summary Table for a fitted object}
\usage{
ResultTableSummary(bstfit)
}
\arguments{
\item{bstfit}{fitted object using the function BSTP, BSTNB or BSTZINB}
}
\value{
summary table
}
\description{
Generates a short summary table for a fitted object using BSTP, BSTNB or BSTZINB function
}
\examples{
data(simdat)
y <- simdat$y
X <- cbind(simdat$V1,simdat$x)
data(county.adjacency)
data(USAcities)
IAcities <- subset(USAcities,state_id=="IA")
countyname <- unique(IAcities$county_name)
A <- get_adj_mat(county.adjacency,countyname,c("IA"))
\donttest{
res3 <- BSTZINB(y, X, A, LinearT=TRUE, nchain=3, niter=100, nburn=20, nthin=1)
ResultTableSummary(res3)
}

}
