% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussianSynLikeGhuryeOlkin.R
\name{gaussianSynLikeGhuryeOlkin}
\alias{gaussianSynLikeGhuryeOlkin}
\title{Estimate the Gaussian synthetic (log) likelihood with an unbiased estimator}
\usage{
gaussianSynLikeGhuryeOlkin(ssy, ssx, log = TRUE, verbose = FALSE)
}
\arguments{
\item{ssy}{The observed summary statisic.}

\item{ssx}{A matrix of the simulated summary statistics. The number
of rows is the same as the number of simulations per iteration.}

\item{log}{A logical argument indicating if the log of likelihood is
given as the result. The default is \code{TRUE}.}

\item{verbose}{A logical argument indicating whether an error message
should be printed if the function fails to compute a likelihood. The
default is \code{FALSE}.}
}
\value{
The estimated synthetic (log) likelihood value.
}
\description{
This function computes an unbiased, nonnegative estimate of a
  normal density function from simulations assumed to be drawn from it. See
  \insertCite{Price2018;textual}{BSL} and
  \insertCite{Ghurye1969;textual}{BSL}.
}
\examples{
data(ma2)
ssy <- ma2_sum(ma2$data)
m <- newModel(fnSim = ma2_sim, fnSum = ma2_sum, simArgs = ma2$sim_args,
              theta0 = ma2$start)
ssx <- simulation(m, n = 300, theta = c(0.6, 0.2), seed = 10)$ssx

# unbiased estimate of the Gaussian synthetic likelihood
# (the likelihood estimator used in uBSL)
gaussianSynLikeGhuryeOlkin(ssy, ssx)

}
\references{
\insertAllCited{}
}
\seealso{
Other available synthetic likelihood estimators:
  \code{\link{gaussianSynLike}} for the standard synthetic likelihood
  estimator, \code{\link{semiparaKernelEstimate}} for the semi-parametric
  likelihood estimator, \code{\link{synLikeMisspec}} for the Gaussian
  synthetic likelihood estimator for model misspecification.
}
