% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcost_RDT.R
\name{bcost_RDT}
\alias{bcost_RDT}
\title{Binomial RDT Cost}
\usage{
bcost_RDT(Cf, Cv, n)
}
\arguments{
\item{Cf}{Fixed costs}

\item{Cv}{Variable costs.}

\item{n}{Optimal test sample size}
}
\value{
Binomial RDT cost
}
\description{
Define the cost function of RDT, mainly determined by the test sample size (for binomial RDT)
}
\examples{
#the n value can be the minimum test sample size obtained from \code{\link{boptimal_n}}.
n_optimal <- 20
bcost_RDT(Cf = 0, Cv = 10, n = n_optimal);
}
\seealso{
\code{\link{bcost_RG}}, \code{\link{bcost_WS}}, \code{\link{bcost_expected}}
}
