% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputeBLOQ.R
\encoding{UTF-8}
\name{imputeBLOQ}
\alias{imputeBLOQ}
\title{impute BLOQ's with various methods}
\usage{
imputeBLOQ(inputData, LOQ, imputationMethod, progressPrint = FALSE, ...)
}
\arguments{
\item{inputData}{numeric matrix or data frame of the size 
n by J (n the sample size and J the number of time points)
 the input dataset}

\item{LOQ}{scalar, limit of quantification value}

\item{imputationMethod}{could be a single string or a vector of strings with the same length as 
the number of time points (ncol(inputData)). If it is left blank, then the imputation is done using 
kernel density estimation method for the columns with at least one non-BLOQ component. For all the
rest (only BLOQ) the constant imputation is used. The allowed values are 
"constant", "ros", "kernel", "cml" corresponding to constant imputation, 
imputing using regression on order statistics, imputing using kernel density estimator, and 
imputing using censored maximum likelihood, respectively.}

\item{progressPrint}{logical variable indicating whether the imputation progress should be printed or not.}

\item{...}{any other argument which should be changed according to the input arguments regarding 
the functions corresponding to different imputation methods.}
}
\value{
a list with two components: imputed dataset, and the methods used to impute each column.
}
\description{
function to impute BLOQ's. The user can define column-specific methods to impute the BLOQ's.
}
\examples{
set.seed(111)
inputData <- simulateBealModelFixedEffects(10, 0.693,1, 1, seq(0.5,3,0.5))
LOQ = 0.125
imputeBLOQ(inputData, LOQ, 
		imputationMethod = c("cml", "ros", "kernel","constant", "constant", "constant"), 
		maxIter = 500, isMultiplicative = TRUE, constantValue = LOQ)
imputeBLOQ(inputData, LOQ, maxIter = 500, isMultiplicative = TRUE, 
constantValue = LOQ/5, epsilon = 1e-04)
}
\author{
Vahid Nassiri, Helen Yvette Barnett
}
