% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BLA-package.R
\docType{package}
\name{BLA-package}
\alias{BLA}
\alias{BLA-package}
\title{BLA: Boundary Line Analysis}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Fits boundary line models to datasets as proposed by Webb (1972) \doi{10.1080/00221589.1972.11514472} and makes statistical inferences about their parameters. Provides additional tools for testing datasets for evidence of boundary presence and selecting initial starting values for model optimization prior to fitting the boundary line models. It also includes tools for conducting post-hoc analyses such as predicting boundary values and identifying the most limiting factor (Miti, Milne, Giller, Lark (2024) \doi{10.1016/j.fcr.2024.109365}). This ensures a comprehensive analysis for datasets that exhibit upper boundary structures.
}
\references{
Lark, R. M., & Milne, A. E. (2016). Boundary line analysis of the
  effect of water filled pore space on nitrous oxide emission from
  cores of arable soil. European Journal of Soil Science, 67 ,
  148-159.

Milne, A. E., Ferguson, R. B., & Lark, R. M. (2006). Estimating a
  boundary line model for a biological response by maximum likelihood.
  Annals of Applied Biology, 149, 223–234.

Schnug, E., Heym, J. M., & Murphy, D. P. L. (1995). Boundary line
  determination technique (BOLIDES). In P. C. Robert, R. H. Rust, &
  W. E. Larson (Eds.), site specific management for agricultural
  systems (p. 899-908). Wiley Online Library.

Webb, R. A. (1972). Use of the boundary line in analysis of biological
  data. Journal of Horticultural Science, 47, 309-319.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://chawezimiti.github.io/BLA/}
  \item Report bugs at \url{https://github.com/chawezimiti/BLA/issues}
}

}
\author{
\strong{Maintainer}: Chawezi Miti \email{chawezi.miti@nottingham.ac.uk} (\href{https://orcid.org/0000-0001-7776-8366}{ORCID}) [copyright holder]

Authors:
\itemize{
  \item Richard M Lark (\href{https://orcid.org/0000-0003-2571-8521}{ORCID})
  \item Alice E Milne (\href{https://orcid.org/0000-0002-4509-0578}{ORCID})
  \item Ken E Giller (\href{https://orcid.org/0000-0002-5998-4652}{ORCID})
}

Other contributors:
\itemize{
  \item Victor O Sadras [contributor]
  \item University of Nottingham/Rothamsted Research [funder]
}

}
\keyword{internal}
