% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models-Model.R
\name{params}
\alias{params}
\title{Extract Parameters from BKT model}
\usage{
params(object)
}
\arguments{
\item{object}{A fitted BKT model object. The model should have been previously fitted using
the \code{fit()} function, otherwise no parameters will be available.}
}
\value{
A data frame containing the fitted model parameters. The data frame will typically include
columns such as 'learns', 'guesses', 'slips', and other model-specific values.
}
\description{
Extract fitted parameters from a BKT model.
This function retrieves the parameters from a fitted BKT model object. The parameters
include model-specific values such as "learns", "guesses", "slips", and "forgets".
These parameters are returned in a format that is easy to print or manipulate for further analysis.
}
\examples{
\donttest{
model <- bkt(seed = 42, parallel = TRUE, num_fits = 5)
result <- fit(model, data_path = "data.csv", skills = "skill name")
params_df <- params(result)
print(params_df)
}
}
