% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernels.R
\name{+.Kernel}
\alias{+.Kernel}
\title{Operator overloading for kernel addition}
\usage{
\method{+}{Kernel}(k1, k2)
}
\arguments{
\item{k1}{Kernel: The left kernel to use for composition}

\item{k2}{Kernel: The right kernel to use for composition}
}
\value{
A new \code{KernelAddComposed} object.
}
\description{
Operator overloading for kernel addition
}
\examples{
\dontshow{if (torch::torch_is_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Create a new additive kernel
k_rq_plus_per <- KernelRQ$new() + KernelPeriodic$new()
# Set the kernel's positions
positions_df <- data.frame(x=c(-4, 0, 3), y=c(-2, 0, 2))
k_rq_plus_per$set_positions(positions_df)
# Generate the kernel's covariance matrix
k_rq_plus_per$kernel_gen()
\dontshow{\}) # examplesIf}
}
