% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernels.R
\name{KernelWhiteNoise}
\alias{KernelWhiteNoise}
\title{R6 class for White Noise Kernels}
\description{
R6 class for White Noise Kernels
}
\examples{
\dontshow{if (torch::torch_is_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Create a new white noise kernel
k_white_noise <- KernelWhiteNoise$new()
# Set the kernel's positions
positions_df <- data.frame(x=c(-4, 0, 3), y=c(-2, 0, 2))
k_white_noise$set_positions(positions_df)
# Generate the kernel's covariance matrix
k_white_noise$kernel_gen()
\dontshow{\}) # examplesIf}
}
\section{Super class}{
\code{\link[BKTR:Kernel]{BKTR::Kernel}} -> \code{KernelWhiteNoise}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{has_dist_matrix}}{Identify if the kernel has a distance matrix or not}

\item{\code{name}}{The kernel's name}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-KernelWhiteNoise-new}{\code{KernelWhiteNoise$new()}}
\item \href{#method-KernelWhiteNoise-core_kernel_fn}{\code{KernelWhiteNoise$core_kernel_fn()}}
\item \href{#method-KernelWhiteNoise-clone}{\code{KernelWhiteNoise$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="BKTR" data-topic="Kernel" data-id="add_jitter_to_kernel"><a href='../../BKTR/html/Kernel.html#method-Kernel-add_jitter_to_kernel'><code>BKTR::Kernel$add_jitter_to_kernel()</code></a></span></li>
<li><span class="pkg-link" data-pkg="BKTR" data-topic="Kernel" data-id="kernel_gen"><a href='../../BKTR/html/Kernel.html#method-Kernel-kernel_gen'><code>BKTR::Kernel$kernel_gen()</code></a></span></li>
<li><span class="pkg-link" data-pkg="BKTR" data-topic="Kernel" data-id="plot"><a href='../../BKTR/html/Kernel.html#method-Kernel-plot'><code>BKTR::Kernel$plot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="BKTR" data-topic="Kernel" data-id="set_positions"><a href='../../BKTR/html/Kernel.html#method-Kernel-set_positions'><code>BKTR::Kernel$set_positions()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KernelWhiteNoise-new"></a>}}
\if{latex}{\out{\hypertarget{method-KernelWhiteNoise-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KernelWhiteNoise$new(kernel_variance = 1, jitter_value = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{kernel_variance}}{Numeric: The variance of the kernel}

\item{\code{jitter_value}}{Numeric: The jitter value to add to the kernel matrix}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{KernelWhiteNoise} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KernelWhiteNoise-core_kernel_fn"></a>}}
\if{latex}{\out{\hypertarget{method-KernelWhiteNoise-core_kernel_fn}{}}}
\subsection{Method \code{core_kernel_fn()}}{
Method to compute the core kernel's covariance matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KernelWhiteNoise$core_kernel_fn()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The core kernel's covariance matrix
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KernelWhiteNoise-clone"></a>}}
\if{latex}{\out{\hypertarget{method-KernelWhiteNoise-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KernelWhiteNoise$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
