% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.initialization.R
\name{data_integration}
\alias{data_integration}
\title{Data Initialization for BICORN}
\usage{
data_integration(Binding_matrix = NULL, Binding_TFs = NULL,
  Binding_genes = NULL, Exp_data, Exp_genes = NULL,
  Minimum_gene_per_module_regulate = 2)
}
\arguments{
\item{Binding_matrix}{loaded prior binding network}

\item{Binding_TFs}{loaded transcription factors}

\item{Binding_genes}{loaded genes in the prior binding network}

\item{Exp_data}{loaded properly normalized gene expression data}

\item{Exp_genes}{loaded genes in the gene expression data}

\item{Minimum_gene_per_module_regulate}{the minimum number of genes regulated by each module, used for candidate module filtering.}
}
\description{
Function 'data_integration' integrates the prior TF-gene binding network and gene expression data together. It will remove any genes missing either TF bindings or gene expression and identify a list of candidate cis-regulatory modules.
}
\examples{

# load in the sample data input
data("sample.input")

# Data initialization (Integerate prior binding network and gene expression data)
BICORN_input<-data_integration(Binding_matrix = Binding_matrix, Binding_TFs = Binding_TFs,
Binding_genes = Binding_genes, Exp_data = Exp_data, Exp_genes = Exp_genes,
Minimum_gene_per_module_regulate = 2)
}
\keyword{Initialization}
