% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{bhai.strataplot}
\alias{bhai.strataplot}
\title{Stratified barplot of cases, deaths and DALYs.}
\usage{
bhai.strataplot(pps, infection, what, col=NULL, errors=TRUE, lwd.errors=2, xlab=NULL, ...)
}
\arguments{
\item{pps}{The PPS object containing the data.}

\item{infection}{Infection to be plotted.}

\item{what}{One of c("Cases", "Deaths", "DALY")}

\item{col}{Color used to fill the bars.}

\item{errors}{Specifying whether error bars should be plotted, default: TRUE.}

\item{lwd.errors}{Line width of error bars.}

\item{xlab}{X-axis labels.}

\item{...}{Further plotting arguments}
}
\description{
Stratified barplot of cases, deaths and DALYs.
}
\examples{
 
data(german_pps_2011_repr)
german_pps_repr = PPS(num_hai_patients = num_hai_patients,
    num_hai_patients_by_stratum = num_hai_patients_by_stratum,
    num_hai_patients_by_stratum_prior = num_hai_patients_by_stratum_prior,
    num_survey_patients = num_survey_patients,
    length_of_stay = length_of_stay,
    loi_pps = loi_pps,
    mccabe_scores_distr = mccabe_scores_distr,
    mccabe_life_exp = mccabe_life_exp,
    hospital_discharges = hospital_discharges,
    population = population,
    country="Germany (representative sample)")
german_pps_repr

set.seed(3)
# The following example is run only for illustratory reasons
# Note that you should never run the function with only 10 Monte-Carlo simulations in practice!
result = bhai(german_pps_repr, nsim=10)
bhai.strataplot(pps=result, infection="HAP", what="Cases")

}
\seealso{
\code{\linkS4class{PPS}}
}
