% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BePlotDiag.R
\name{BePlotDiag}
\alias{BePlotDiag}
\title{Diagnosis plots for PI, U, C and Epsilon}
\usage{
BePlotDiag(M, variable = "PI", pos = 1)
}
\arguments{
\item{M}{Tibble. Contains the output by
\code{BeMRes}}

\item{variable}{Either "PI", "U", "C" or "Epsilon". Variable for which
diagnostic plot will be shown.}

\item{pos}{Positive integer. Position of the selected \code{variable} to be
plotted.}
}
\description{
Diagnostic plots for hazard rate (PI), latent variable (U), dependence
parameter (C) and parameter of the hierarchical model (Epsilon).
}
\details{
This function returns a diagnostics plot for the chain of the selected
variable. The diagnostics includes trace, ergodic mean, autocorrelation
function and histogram.
}
\examples{



## Simulations may be time intensive. Be patient.

## Example 1
#  data(psych)
#  timesP <- psych$time
#  deltaP <- psych$death
#  BEX1 <- BeMRes(timesP, deltaP, iterations = 3000, burn.in = 300, thinning = 1)
#  BePlotDiag(BEX1, variable = "PI", pos = 2)
#  BePlotDiag(BEX1, variable = "U", pos = 3)

## Example 2
#  data(gehan)
#  timesG <- gehan$time[gehan$treat == "control"]
#  deltaG <- gehan$cens[gehan$treat == "control"]
#  BEX2 <- BeMRes(timesG, deltaG, type.c = 2, c.r = rep(50, 22))
#  BePlotDiag(BEX2, variable = "PI", pos = 5)
#  BePlotDiag(BEX2, variable = "U", pos = 4)



}
\references{
- Nieto-Barajas, L. E. & Walker, S. G. (2002). Markov beta and
gamma processes for modelling hazard rates. \emph{Scandinavian Journal of
Statistics} \strong{29}: 413-424.
}
\seealso{
\link{BeMRes}
}
