% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGeneDescription.R
\name{getGeneDescription}
\alias{getGeneDescription}
\title{Get description of genes corresponding to Biological Entity identifiers}
\usage{
getGeneDescription(
  ids,
  be,
  source,
  organism,
  gsource = largestBeSource(be = "Gene", organism = organism, rel = "is_known_as",
    restricted = TRUE),
  limForCache = 2000
)
}
\arguments{
\item{ids}{list of identifiers}

\item{be}{one BE. \strong{Guessed if not provided}}

\item{source}{the BE ID database. \strong{Guessed if not provided}}

\item{organism}{organism name. \strong{Guessed if not provided}}

\item{gsource}{the source of the gene IDs to use. It's chosen automatically
by default.}

\item{limForCache}{The number of ids above which the description
is gathered for all be IDs and cached for  futur queries.}
}
\value{
a data.frame providing for each BE IDs
(row.names are provided BE IDs):
\itemize{
\item \strong{id}: the BE ID
\item \strong{gsource}: the Gene ID the column name provides the source of the
used identifier
\item \strong{symbol}: the associated gene symbols
\item \strong{name}: the associated gene names
}
}
\description{
This description can be used for annotating tables or graph based on BE IDs.
}
\examples{
\dontrun{
getGeneDescription(
   ids=c("1438_at", "1552335_at"),
   be="Probe",
   source="GPL570",
   organism="human"
)
}

}
\seealso{
\link{getBeIdDescription}, \link{getBeIdNames}, \link{getBeIdSymbols}
}
