\name{BCA1SG_NHPP}
\alias{BCA1SG_NHPP}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
BCA1SG algorithm for panel count data
}
\description{
This function implements the BCA1SG algorithm on the semiparametric nonhomogeneous Poisson process model for panel count data to solve the ML estimates of the model parameters.
}
\usage{
BCA1SG_NHPP(input_data, initial_beta, initial_Lambda = function(x){x}, threshold = 1e-05,
            max_iter = 5000, max_stepsize = 10000, xi = 0.3, contraction = 0.5)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{input_data}{
An object of class data.frame.
The structure of the data frame must be
\{patient ID, time of measurement, measurement(cumulative counts),covariate_1,...,covariate_p\}.
This data frame cannot contain missing values. See the dataset "skiTum" for an example.
}
  \item{initial_beta}{
The initial value of the regression coefficients.
The dimension of this input should comply with the dimension of the covariates.
}
  \item{initial_Lambda}{
An R function which serves as the initial value of the baseline mean cumulative function.
}
  \item{threshold}{
Convergence threshold. The algorithm is terminated when the infinity norm of the difference between successive iterates is less than the convergence threshold.
}
  \item{max_iter}{
Maximum number of iterations allowed.
}
  \item{max_stepsize}{
Maximum stepsize allowed.
}
  \item{xi}{
The xi parameter in the inexact backtracking line search algorithm. See Wang et al. (2020) for details.
}
  \item{contraction}{
The contraction parameter in the inexact backtracking line search algorithm. See Wang et al. (2020) for details.
}
}
\details{
Details about the BCA1SG algorithm can be found in Wang et al. (2020), and the details concerning the semiparametric NHPP model can be found in Wellner and Zhang (2007).
}
\value{
  \item{distinct_time}{The set of distinct observation time points.}
  \item{est_Lambda}{The estimated baseline mean cumulative function at the set of distinct observation time points.}
  \item{est_beta}{The estimated regression coefficients.}
  \item{iteration}{The number of iterations.}
  \item{timecost}{The computational time in seconds.}
}
\references{
Wang Y., Ye, Z.-S., and Cao, H.(2020). On Computation of Semi-Parametric Maximum Likelihood Estimators with Shape Constraints. Submitted.

Wellner J.A. and Zhang Y.(2007). Two Likelihood-Based Semiparametric Estimation Methods for Panel Count Data with Covariates. The Annals of Statistics, 35(5), 2106-2142.
}
\author{
Wang Y., Ye Z., and Cao H.
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\examples{
data(adapt_skiTum)
res<-BCA1SG_NHPP(adapt_skiTum, initial_beta = rep(0,4), threshold = 2e-3)
res$est_beta
res$iteration
res$timecost
plot(res$distinct_time,res$est_Lambda,type="s",lwd=3,
xlab="Time",ylab="Baseline mean cumulative function")
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{NHPP}% use one of  RShowDoc("KEYWORDS")
