% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_priors.R
\name{Jeffreys}
\alias{Jeffreys}
\title{Jeffreys Prior Distribution for $g$ for Mixtures of g-Priors for
Coefficients in BMA Models}
\usage{
Jeffreys()
}
\value{
returns an object of class "prior", with the family and
hyerparameters.
}
\description{
Creates an object representing the Jeffrey's Prior on g mixture of g-priors
on coefficients for BAS. This is equivalent to a limiting version of the
CCH(a, 2, 0) with a = 0 or they hyper-g(a = 2) and is an improper prior.  As
$g$ does not appear in the Null Model, Bayes Factors and model probabilities
are not well-defined because of arbitrary normalizing constants, and for
this reason the null model is excluded and the same constants are used
across other models.
}
\details{
Creates a structure used for \code{\link{bas.glm}}.
}
\examples{
Jeffreys()
}
\seealso{
\code{\link{CCH}} \code{\link{bas.glm}}

Other beta priors: 
\code{\link{CCH}()},
\code{\link{EB.local}()},
\code{\link{IC.prior}()},
\code{\link{TG}()},
\code{\link{beta.prime}()},
\code{\link{g.prior}()},
\code{\link{hyper.g}()},
\code{\link{hyper.g.n}()},
\code{\link{intrinsic}()},
\code{\link{robust}()},
\code{\link{tCCH}()},
\code{\link{testBF.prior}()}
}
\author{
Merlise Clyde
}
\concept{beta priors}
