% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap_decision.R
\name{heatmap_decision}
\alias{heatmap_decision}
\title{Heatmap for Decision Rules}
\usage{
heatmap_decision(object, decision.rule, y1.display = NA, y2.display = NA)
}
\arguments{
\item{object}{An object of "BAC" class.}

\item{decision.rule}{A vector of \code{c(a,b)} specifying the decision rule.
See help for \code{decision_eval} function.}

\item{y1.display, y2.display}{A subset of control/treatment number of events
to be displayed.}
}
\description{
Visualizing a decision rule for binary endpoint using heatmap
  plots
}
\examples{
\dontrun{
#borrow from 3 historical trials#
yh = c(11,300,52);nh = c(45,877,128)
#specify current trial sample sizes#
n1 = 20;n2 = 30
obj = BAC_binom(yh=yh,nh=nh,n1=n1,n2=n2,n.chain=5,
criterion.type="prob",prob.threshold=0.1,sim.mode="express")

#generate full heatmap
heatmap_decision(obj,decision.rule=c(0.05,0.15))
#generate partial heatmap
heatmap_decision(obj,decision.rule=c(0.05,0.15),y1.display=5:15,y2.display=10:25)

}
}
\author{
Hongtao Zhang
}

