% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_methods.R
\name{get_vm}
\alias{get_vm}
\alias{get_vm_scaleset}
\alias{get_vm_resource}
\alias{get_vm_scaleset_resource}
\title{Get existing virtual machine(s)}
\description{
Method for the \link[AzureRMR:az_subscription]{AzureRMR::az_subscription} and \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group} classes.
}
\section{Usage}{
\preformatted{## R6 method for class 'az_subscription'
get_vm(name, resource_group = name)

## R6 method for class 'az_resource_group'
get_vm(name)

## R6 method for class 'az_subscription'
get_vm_scaleset(name, resource_group = name)

## R6 method for class 'az_resource_group'
get_vm_scaleset(name)

## R6 method for class 'az_resource_group')
get_vm_resource(name)
get_vm_scaleset_resource(name)
}
}

\section{Arguments}{

\itemize{
\item \code{name}: The name of the VM or scaleset.
\item \code{resource_group}: For the \code{az_subscription} methods, the resource group in which \code{get_vm()} and \code{get_vm_scaleset()}  will look for the VM or scaleset. Defaults to the VM name.
}
}

\section{Value}{

For \code{get_vm()}, an object representing the VM deployment. This will include other resources besides the VM itself, such as the network interface, virtual network, etc.

For \code{get_vm_scaleset()}, an object representing the scaleset deployment. Similarly to \code{get_vm()}, this includes other resources besides the scaleset.

For \code{get_vm_resource()} and \code{get_vm_scaleset_resource()}, the VM or scaleset resource itself.
}

\examples{
\dontrun{

sub <- AzureRMR::get_azure_login()$
    get_subscription("subscription_id")

sub$get_vm("myvirtualmachine")
sub$get_vm_scaleset("myscaleset")

rg <- sub$get_resource_group("rgname")
rg$get_vm("myothervirtualmachine")
rg$get_vm_scaleset("myotherscaleset")

}
}
\seealso{
\link{az_vm_template}, \link{az_vm_resource}, \link{az_vmss_template}, \link{az_vmss_resource} for the methods available for working with VMs and VM scalesets.

\link[AzureRMR:az_subscription]{AzureRMR::az_subscription}, \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group}
}
