% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demo.R
\name{demo}
\alias{demo}
\title{Demonstration of Application Insights}
\usage{
demo(
  connectionString,
  debug = TRUE,
  appId = "Test AzureAppInsights",
  launch.browser = FALSE,
  instrumentationKey
)
}
\arguments{
\item{connectionString, instrumentationKey}{Credentials for sending to Application Insights.
See arguments for \code{\link{config}}.}

\item{debug}{Logical, see \code{\link{startAzureAppInsights}}.}

\item{appId}{A id for this particular application.}

\item{launch.browser}{Logical, see \code{\link[shiny]{runApp}}.}
}
\description{
Launches a simple demonstration of using Application Insights for Shiny apps.
Requires that you have a Microsoft Azure Application Insights resource to
send to; demonstration will still work -- your metrics will just be sent to oblivion.
}
\details{
It may take some minutes before the values sent to Application Insights are
visible in the logs on portal.azure.com.

If neither \code{connectionString} nor \code{instrumentationKey} is provided,
a connection string is found in the environment variable \code{AAI_CONNSTR}.
}
\examples{
connstr <- paste0(
  'InstrumentationKey=00000000-0000-0000-0000-000000000000;',
  'IngestionEndpoint=https://northeurope-0.in.applicationinsights.azure.com/;',
  'LiveEndpoint=https://northeurope.livediagnostics.monitor.azure.com/')
\dontrun{
 demo(connstr)
}
}
