% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anatomicalmassprop.R
\name{massprop_feathers}
\alias{massprop_feathers}
\title{Feather mass properties}
\usage{
massprop_feathers(
  m_f,
  l_c,
  l_r_cor,
  w_cal,
  r_b,
  d_b,
  rho_cor,
  rho_med,
  w_vp,
  w_vd,
  angle
)
}
\arguments{
\item{m_f}{Mass of the entire feather (kg)}

\item{l_c}{Length of the calamus; start of vane to end of calamus(m)}

\item{l_r_cor}{Length of rachis; tip to start of vane (m)}

\item{w_cal}{Width (diameter) of the cortex part of the calamus (m)}

\item{r_b}{Radius of feather barbs (m)}

\item{d_b}{Distance between barbs (m)}

\item{rho_cor}{Density of the cortex (kg/m^3)}

\item{rho_med}{Density of the medullary (kg/m^3)}

\item{w_vp}{Width of proximal (closest to body) vane (m)}

\item{w_vd}{Width of distal (closest to wing tip) vane (m)}

\item{angle}{Angle between calamus and the vane taken the supplement angle
to the interior angle. Negative indicates the feather tip is rotated
proximally relative to the start of the feather vane.}
}
\value{
a list that includes:
\itemize{
\item{I}{a 3x3 matrix representing the moment of inertia tensor of a
simplified feather with the origin at the feather calamus end and within
the feather frame of reference}
\item{CG}{a 1x3 vector representing the center of gravity position of a
simplified feather with the origin at the feather calamus end and within
the feather frame of reference}
\item{m}{a double that returns the feather mass}
}
}
\description{
Calculate the moment of inertia of the feathers within the
feather frame of reference.
}
\section{Warning}{

Parallel axis theorem does not apply between two arbitrary points.
One point must be the object's center of gravity.

CAUTION: While computing the variable components of the feather the x axis
is the normal of the feather.
}

\examples{
# refer to the vignette
library(AvInertia)

# load data
data(dat_id_curr, package = "AvInertia")
data(dat_bird_curr, package = "AvInertia")
data(dat_feat_curr, package = "AvInertia")
data(dat_bone_curr, package = "AvInertia")
data(dat_mat, package = "AvInertia")
data(clean_pts, package = "AvInertia")

# 1. Determine the center of gravity of the bird's torso (including the legs)
dat_torsotail_out = massprop_restbody(dat_id_curr, dat_bird_curr)
# 2. Calculate the inertia of the flight feathers about the tip of the calamus
feather_inertia <- compute_feat_inertia(dat_mat, dat_feat_curr, dat_bird_curr)
# 3. Determine the center of gravity of one of the bird's wings
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = 0)
# Visualize the center of gravity of each wing component in the x and y axis
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = "yx")
# or the y and z axis
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = "yz")
# 4. Combine all data and obtain the center of gravity, moment of inertia
# and principal axes of the bird
curr_full_bird      = combine_inertialprop(dat_torsotail_out,dat_wing_out,
dat_wing_out, dat_id_curr, dat_bird_curr, symmetric=TRUE)

}
\author{
Christina Harvey
}
