% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ARMDE.R
\name{ARMDE}
\alias{ARMDE}
\title{Performs minimum distance estimation in autoregressive model}
\usage{
ARMDE(X, AR_Order)
}
\arguments{
\item{X}{: vector of n observed value}

\item{AR_Order}{: oder of the autoregressive model}
}
\value{
returns minimum distance estimators of the parameter in the autoregressive model
}
\description{
Performs minimum distance estimation in autoregressive model
}
\examples{
X <- rnorm(10, mean=0, sd=1)
AR_Order <- 2
rhohat<-ARMDE(X,AR_Order)
}
\references{
[1] Koul, H. L (1985). Minimum distance estimation in linear regression with unknown error distributions. Statist. Probab. Lett., 3 1-8.

[2] Koul, H. L (1986). Minimum distance estimation and goodness-of-fit tests in first-order autoregression. Ann. Statist., 14 1194-1213.

[3] Koul, H. L (2002). Weighted empirical process in nonlinear dynamic models. Springer, Berlin, Vol. 166
}
\seealso{
LRMDE
}

