% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallelTables.R
\name{parallelTables}
\alias{parallelTables}
\title{Place two or more ztables or figures side by side in Latex or HTML format}
\usage{
parallelTables(width, listTables, type = "latex")
}
\arguments{
\item{width}{a numeric vector specifies the width to which the tables or
figures should be scaled}

\item{listTables}{a list consists of object of "ztable" or valid figure name}

\item{type}{Type of table to produce. Possible values for type are "latex" or
"html". Default value is "latex".}
}
\description{
Place two or more ztables or figures side by side in Latex or HTML format.
Requires Latex "boxedminipage" package in preamble.
The ztable for this purpose should be made by function ztable with tabular="TRUE".
}
\examples{
require(ztable)
z=ztable(head(mtcars[1:3]),tabular=TRUE)
parallelTables(c(0.4,0.3),list(z,z))
parallelTables(c(0.5,0.5),list(z,z))
parallelTables(c(0.5,0.5),list(z,z,type="html"))
z1=ztable(head(iris[1:3]),turn=TRUE,angle=10,zebra=1)
z2=ztable(head(iris[1:3]),turn=TRUE,angle=-10,zebra=2)
parallelTables(c(0.5,0.5),list(z1,z2))
}
