% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RerunWorkflow.R
\name{RerunWorkflow}
\alias{RerunWorkflow}
\title{Rerun a workflow object.}
\usage{
RerunWorkflow(workflow, from = NULL)
}
\arguments{
\item{workflow}{A zoonWorkflow object from a previous zoon analysis}

\item{from}{Which modules should be run. If NULL (default), run from the
first NULL output (i.e. where the workflow broke). Otherwise takes an
integer and runs from that module.}
}
\value{
A list with the results of each module and a copy of the
 call used to execute the workflow.
}
\description{
Takes a workflow object and reruns it.
}
\examples{
\dontrun{
w <- workflow(UKAnophelesPlumbeus,
              UKAir,
              OneHundredBackground, 
              LogisticRegression,
              PrintMap)

RerunWorkflow(w)
}
}

