



#[derive(Copy, Clone, PartialEq, Debug)]
pub enum MinMaxResult<T> {

    NoElements,


    OneElement(T),



    MinMax(T, T)
}

impl<T: Clone> MinMaxResult<T> {




















    pub fn into_option(self) -> Option<(T,T)> {
        match self {
            MinMaxResult::NoElements => None,
            MinMaxResult::OneElement(x) => Some((x.clone(), x)),
            MinMaxResult::MinMax(x, y) => Some((x, y))
        }
    }
}


pub fn minmax_impl<I, K, F, L>(mut it: I, mut key_for: F,
                               mut lt: L) -> MinMaxResult<I::Item>
    where I: Iterator,
          F: FnMut(&I::Item) -> K,
          L: FnMut(&I::Item, &I::Item, &K, &K) -> bool,
{
    let (mut min, mut max, mut min_key, mut max_key) = match it.next() {
        None => return MinMaxResult::NoElements,
        Some(x) => {
            match it.next() {
                None => return MinMaxResult::OneElement(x),
                Some(y) => {
                    let xk = key_for(&x);
                    let yk = key_for(&y);
                    if !lt(&y, &x, &yk, &xk) {(x, y, xk, yk)} else {(y, x, yk, xk)}
                }
            }
        }
    };

    loop {





        let first = match it.next() {
            None => break,
            Some(x) => x
        };
        let second = match it.next() {
            None => {
                let first_key = key_for(&first);
                if lt(&first, &min, &first_key, &min_key) {
                    min = first;
                } else if !lt(&first, &max, &first_key, &max_key) {
                    max = first;
                }
                break;
            }
            Some(x) => x
        };
        let first_key = key_for(&first);
        let second_key = key_for(&second);
        if !lt(&second, &first, &second_key, &first_key) {
            if lt(&first, &min, &first_key, &min_key) {
                min = first;
                min_key = first_key;
            }
            if !lt(&second, &max, &second_key, &max_key) {
                max = second;
                max_key = second_key;
            }
        } else {
            if lt(&second, &min, &second_key, &min_key) {
                min = second;
                min_key = second_key;
            }
            if !lt(&first, &max, &first_key, &max_key) {
                max = first;
                max_key = first_key;
            }
        }
    }

    MinMaxResult::MinMax(min, max)
}
