







use num_traits::Float;
use crate::{uniform::SampleUniform, Distribution, Uniform};
use rand::Rng;



















#[derive(Clone, Copy, Debug)]
#[cfg_attr(feature = "serde1", derive(serde::Serialize, serde::Deserialize))]
pub struct UnitCircle;

impl<F: Float + SampleUniform> Distribution<[F; 2]> for UnitCircle {
    #[inline]
    fn sample<R: Rng + ?Sized>(&self, rng: &mut R) -> [F; 2] {
        let uniform = Uniform::new(F::from(-1.).unwrap(), F::from(1.).unwrap());
        let mut x1;
        let mut x2;
        let mut sum;
        loop {
            x1 = uniform.sample(rng);
            x2 = uniform.sample(rng);
            sum = x1 * x1 + x2 * x2;
            if sum < F::from(1.).unwrap() {
                break;
            }
        }
        let diff = x1 * x1 - x2 * x2;
        [diff / sum, F::from(2.).unwrap() * x1 * x2 / sum]
    }
}

#[cfg(test)]
mod tests {
    use super::UnitCircle;
    use crate::Distribution;

    #[test]
    fn norm() {
        let mut rng = crate::test::rng(1);
        for _ in 0..1000 {
            let x: [f64; 2] = UnitCircle.sample(&mut rng);
            assert_almost_eq!(x[0] * x[0] + x[1] * x[1], 1., 1e-15);
        }
    }
}
