% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yearmon_style.R
\name{melt_month}
\alias{melt_month}
\title{Translate \code{zoomly} objects to yearmon format}
\usage{
melt_month(x)
}
\arguments{
\item{x}{a zoomly object.}
}
\description{
Melt the month information of a \code{zoomly} object into the index, 
and return a "\code{zoo}" object with the index of "\code{yearmon}" class.
}
\examples{
x <- matrix(1 : 20, nrow = 5)
zm <- zoomly(x, order.by = 1991 : 1995, 
             colattr = data.frame(month = c(2, 3, 5, 6)))
melt_month(zm)

x <- matrix(1 : 20, nrow = 5)
colAttr <- data.frame(month = c(2, 3, 5, 6), name = c(rep('xxx', 3), 'yyy'))
zc <- zoocat(x, order.by = 1991 : 1995, colattr = colAttr)
melt_month(as.zoomly(zc))

}

