% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cattr.R
\name{cattr}
\alias{cattr}
\alias{cattr.zoocat}
\alias{cattr<-}
\alias{cattr<-.zoo}
\alias{cattr<-.zoocat}
\title{Getting or setting the column attributes table of a \code{zoocat} object.}
\usage{
cattr(x) <- value

\method{cattr}{zoocat}(x) <- value

\method{cattr}{zoo}(x) <- value

cattr(x)

\method{cattr}{zoocat}(x)
}
\arguments{
\item{x}{A \code{zoocat} or \code{zoo} object.}

\item{value}{The new value.}
}
\value{
"\code{cattr(x)}" return a data frame.
}
\description{
Getting or setting the column attributes table of a "\code{zoocat}" object. Using \code{cattr(x) <- value} 
can translate a "\code{zoo}" object to a "\code{zoocat}" object.
}
\examples{

x <- matrix(1 : 20, nrow = 5)
colAttr <- data.frame(month = c(2, 3, 5, 6), name = 'x')
zc <- zoocat(x, order.by = 1991 : 1995, colattr = colAttr)
cattr(zc)[, 2] <- 'y'

zobj <- zoo(x, order.by = 1991 : 1995)
cattr(zobj) <- colAttr

}

