% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.zoocat.R
\name{as.zoocat}
\alias{as.zoocat}
\alias{as.zoocat.zoo}
\alias{as.zoocat.zoomly}
\title{Coercing objects to Class \code{zoocat}}
\usage{
as.zoocat(x, ...)

\method{as.zoocat}{zoomly}(x, ...)

\method{as.zoocat}{zoo}(x, colattr = NULL, variable.name = "variable",
  index.name = "index", ...)
}
\arguments{
\item{x}{the object.}

\item{...}{other arguments passed to methods.}

\item{colattr}{a data frame the column attribute table for x.}

\item{variable.name}{the name of the field in the \code{cattr} of 
the output \code{zoocat} object to store the variable name.}

\item{index.name}{the name of the index variable.}
}
\value{
a "\code{zoocat}" object.
}
\description{
Coercing objects to class \code{zoocat}.
}
\examples{

x <- matrix(1 : 20, nrow = 5)
zm <- zoomly(x, order.by = 1991 : 1995, colattr = data.frame(month = c(2, 3, 5, 6)))
as.zoocat(zm)

zobj <- zoo(matrix(1:10, nrow = 5), order.by = 11:15)
colnames(zobj) <- c('a', 'b')
as.zoocat(zobj)

}

